<?php
session_start();
if (!(isset($_SESSION['username']) && $_SESSION['username'] != '')) {
    header ("Location:index.php");
    exit();
}

$url = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
$furl = str_replace("create_AR.php", "", $url);
?>
<!DOCTYPE html>
<html>
<head>
    <?php include 'top_includes.php'; ?>
</head>
<body>
<div class="all-wrapper menu-side">
<div class="layout-w">
<?php include "header.php"; ?>
<div class="content-w">
<div class="content-i">
<div class="content-box">

<div class="row">
<div class="col-lg-12">

<form method="post">
    
    <!-- HIDDEN FIELDS WILL STORE FILENAMES -->
    <input type="hidden" name="glb_file" id="glb_file">
    <input type="hidden" name="usdz_file" id="usdz_file">

    <div class="element-wrapper">
        <div class="form-box-w panel">

            <!-- GLB Upload -->
            <legend><span>GLB Model</span></legend>
            <center>
                <input type="file" name="file1" id="file1" onchange="loadFile(event)" class="inputfile" accept=".glb">
                <p id="imageText" style="padding-top:56px;font-size:20px;">Drop file here or Click to upload</p>
            </center>
            <center>
                <button type="button" class="btn btn-primary" onclick="uploadFile()">Upload GLB model</button><br>
                <progress id="progressBar" value="0" max="100" style="margin-top:10px;height:40px;width:70%;"></progress><br>
                <span id="status"></span>
                <p id="loaded_n_total"></p>
            </center>

            <br>

            <!-- USDZ Upload -->
            <legend><span>USDZ Model</span></legend>
            <center>
                <input type="file" name="file2" id="file2" onchange="loadFile2(event)" class="inputfile" accept=".usdz">
                <p id="imageText2" style="padding-top:56px;font-size:20px;">Drop file here or Click to upload</p>
            </center>
            <center>
                <button type="button" class="btn btn-primary" onclick="uploadFile2()">Upload USDZ model</button><br>
                <progress id="progressBar2" value="0" max="100" style="margin-top:10px;height:40px;width:70%;"></progress><br>
                <span id="status2"></span>
                <p id="loaded_n_total2"></p>
            </center>

        </div>
    </div>

    <button class="btn btn-primary" name="upload" type="submit" style="width:100%;"> PROCEED DATA</button>

</form>

</div>
</div>

<div class="display-type"></div>
</div>
</div>

<?php include 'bottom_includes.php'; ?>
</body>
</html>

<script>
// Short function to access elements by ID
function _(el){ return document.getElementById(el); }

/* ---------------- GLB UPLOAD ---------------- */
function uploadFile(){
    var file = _("file1").files[0];
    var formdata = new FormData();
    formdata.append("file1", file);

    var ajax = new XMLHttpRequest();
    ajax.upload.addEventListener("progress", progressHandler);
    ajax.addEventListener("load", completeHandler);
    ajax.addEventListener("error", errorHandler);
    ajax.addEventListener("abort", abortHandler);
    ajax.open("POST", "glb_upload_parser.php");
    ajax.send(formdata);
}

function progressHandler(event){
    _("loaded_n_total").innerHTML = "Uploaded "+event.loaded+" bytes of "+event.total;
    var percent = (event.loaded / event.total) * 100;
    _("progressBar").value = Math.round(percent);
    _("status").innerHTML = Math.round(percent)+"% uploaded... please wait";
}

function completeHandler(event){
    _("status").innerHTML = "Uploaded!";
    _("progressBar").value = 100;

    // Save filename returned from PHP
    _("glb_file").value = event.target.responseText;
}

function errorHandler(event){ _("status").innerHTML = "Upload Failed"; }
function abortHandler(event){ _("status").innerHTML = "Upload Aborted"; }

/* ---------------- USDZ UPLOAD ---------------- */
function uploadFile2(){
    var file = _("file2").files[0];
    var formdata = new FormData();
    formdata.append("file2", file);

    var ajax = new XMLHttpRequest();
    ajax.upload.addEventListener("progress", progressHandler2);
    ajax.addEventListener("load", completeHandler2);
    ajax.addEventListener("error", errorHandler2);
    ajax.addEventListener("abort", abortHandler2);
    ajax.open("POST", "usdz_upload_parser.php");
    ajax.send(formdata);
}

function progressHandler2(event){
    _("loaded_n_total2").innerHTML = "Uploaded "+event.loaded+" bytes of "+event.total;
    var percent = (event.loaded / event.total) * 100;
    _("progressBar2").value = Math.round(percent);
    _("status2").innerHTML = Math.round(percent)+"% uploaded... please wait";
}

function completeHandler2(event){
    _("status2").innerHTML = "Uploaded!";
    _("progressBar2").value = 100;

    _("usdz_file").value = event.target.responseText;
}

function errorHandler2(event){ _("status2").innerHTML = "Upload Failed"; }
function abortHandler2(event){ _("status2").innerHTML = "Upload Aborted"; }

/* Show filename after uploading */
var loadFile = function(event) {
    var onlyname = _("file1").value.split(/(\\|\/)/g).pop();
    _("imageText").innerHTML = onlyname;
};
var loadFile2 = function(event) {
    var onlyname = _("file2").value.split(/(\\|\/)/g).pop();
    _("imageText2").innerHTML = onlyname;
};
</script>

<?php
/* ---------------- FINAL PHP PROCESS ---------------- */
if (isset($_POST['upload'])) {

    $glb  = $_POST['glb_file'];
    $usdz = $_POST['usdz_file'];

    include 'db/connection.php';

    $sql = "INSERT INTO objects (qrcode, glb, usdz) VALUES ('empty', '$glb', '$usdz')";
    mysqli_query($conn, $sql);

    $latest_id = mysqli_insert_id($conn);
    $link = $furl . "viewAR.php?id=" . $latest_id;

    require_once('phpqrcode/qrlib.php');
    $tempDir = __DIR__ . '/qrcodes/';
    if (!is_dir($tempDir)) mkdir($tempDir, 0777, true);

    $fileName = 'qr_' . md5($link) . '.png';
    $pngAbsoluteFilePath = $tempDir . $fileName;

    QRcode::png($link, $pngAbsoluteFilePath, QR_ECLEVEL_L, 10);

    $sqli = "UPDATE objects SET qrcode='$fileName' WHERE id='$latest_id'";
    mysqli_query($conn, $sqli);

    echo "<script>window.location.href='asset_management.php';</script>";
}
?>